// Code generated by github.com/whyrusleeping/cbor-gen. DO NOT EDIT.

package internal

import (
	"fmt"
	"io"
	"math"
	"sort"

	datatransfer "github.com/filecoin-project/go-data-transfer/v2"
	cid "github.com/ipfs/go-cid"
	peer "github.com/libp2p/go-libp2p/core/peer"
	cbg "github.com/whyrusleeping/cbor-gen"
	xerrors "golang.org/x/xerrors"
)

var _ = xerrors.Errorf
var _ = cid.Undef
var _ = math.E
var _ = sort.Sort

func (t *ChannelState) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{184, 24}); err != nil {
		return err
	}

	// t.Sent (uint64) (uint64)
	if len("Sent") > 8192 {
		return xerrors.Errorf("Value in field \"Sent\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Sent"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Sent")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Sent)); err != nil {
		return err
	}

	// t.Queued (uint64) (uint64)
	if len("Queued") > 8192 {
		return xerrors.Errorf("Value in field \"Queued\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Queued"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Queued")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Queued)); err != nil {
		return err
	}

	// t.Sender (peer.ID) (string)
	if len("Sender") > 8192 {
		return xerrors.Errorf("Value in field \"Sender\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Sender"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Sender")); err != nil {
		return err
	}

	if len(t.Sender) > 8192 {
		return xerrors.Errorf("Value in field t.Sender was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Sender))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Sender)); err != nil {
		return err
	}

	// t.Stages (datatransfer.ChannelStages) (struct)
	if len("Stages") > 8192 {
		return xerrors.Errorf("Value in field \"Stages\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Stages"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Stages")); err != nil {
		return err
	}

	if err := t.Stages.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Status (datatransfer.Status) (uint64)
	if len("Status") > 8192 {
		return xerrors.Errorf("Value in field \"Status\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Status"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Status")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Status)); err != nil {
		return err
	}

	// t.BaseCid (cid.Cid) (struct)
	if len("BaseCid") > 8192 {
		return xerrors.Errorf("Value in field \"BaseCid\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("BaseCid"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("BaseCid")); err != nil {
		return err
	}

	if err := cbg.WriteCid(cw, t.BaseCid); err != nil {
		return xerrors.Errorf("failed to write cid field t.BaseCid: %w", err)
	}

	// t.Message (string) (string)
	if len("Message") > 8192 {
		return xerrors.Errorf("Value in field \"Message\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Message"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Message")); err != nil {
		return err
	}

	if len(t.Message) > 8192 {
		return xerrors.Errorf("Value in field t.Message was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Message))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Message)); err != nil {
		return err
	}

	// t.Received (uint64) (uint64)
	if len("Received") > 8192 {
		return xerrors.Errorf("Value in field \"Received\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Received"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Received")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Received)); err != nil {
		return err
	}

	// t.Selector (internal.CborGenCompatibleNode) (struct)
	if len("Selector") > 8192 {
		return xerrors.Errorf("Value in field \"Selector\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Selector"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Selector")); err != nil {
		return err
	}

	if err := t.Selector.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.SelfPeer (peer.ID) (string)
	if len("SelfPeer") > 8192 {
		return xerrors.Errorf("Value in field \"SelfPeer\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("SelfPeer"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("SelfPeer")); err != nil {
		return err
	}

	if len(t.SelfPeer) > 8192 {
		return xerrors.Errorf("Value in field t.SelfPeer was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.SelfPeer))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.SelfPeer)); err != nil {
		return err
	}

	// t.Vouchers ([]internal.EncodedVoucher) (slice)
	if len("Vouchers") > 8192 {
		return xerrors.Errorf("Value in field \"Vouchers\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Vouchers"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Vouchers")); err != nil {
		return err
	}

	if len(t.Vouchers) > 8192 {
		return xerrors.Errorf("Slice value in field t.Vouchers was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Vouchers))); err != nil {
		return err
	}
	for _, v := range t.Vouchers {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}

	}

	// t.DataLimit (uint64) (uint64)
	if len("DataLimit") > 8192 {
		return xerrors.Errorf("Value in field \"DataLimit\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("DataLimit"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("DataLimit")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.DataLimit)); err != nil {
		return err
	}

	// t.Initiator (peer.ID) (string)
	if len("Initiator") > 8192 {
		return xerrors.Errorf("Value in field \"Initiator\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Initiator"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Initiator")); err != nil {
		return err
	}

	if len(t.Initiator) > 8192 {
		return xerrors.Errorf("Value in field t.Initiator was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Initiator))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Initiator)); err != nil {
		return err
	}

	// t.Recipient (peer.ID) (string)
	if len("Recipient") > 8192 {
		return xerrors.Errorf("Value in field \"Recipient\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Recipient"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Recipient")); err != nil {
		return err
	}

	if len(t.Recipient) > 8192 {
		return xerrors.Errorf("Value in field t.Recipient was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Recipient))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Recipient)); err != nil {
		return err
	}

	// t.Responder (peer.ID) (string)
	if len("Responder") > 8192 {
		return xerrors.Errorf("Value in field \"Responder\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Responder"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Responder")); err != nil {
		return err
	}

	if len(t.Responder) > 8192 {
		return xerrors.Errorf("Value in field t.Responder was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Responder))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Responder)); err != nil {
		return err
	}

	// t.TotalSize (uint64) (uint64)
	if len("TotalSize") > 8192 {
		return xerrors.Errorf("Value in field \"TotalSize\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("TotalSize"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("TotalSize")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.TotalSize)); err != nil {
		return err
	}

	// t.TransferID (datatransfer.TransferID) (uint64)
	if len("TransferID") > 8192 {
		return xerrors.Errorf("Value in field \"TransferID\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("TransferID"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("TransferID")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.TransferID)); err != nil {
		return err
	}

	// t.VoucherResults ([]internal.EncodedVoucherResult) (slice)
	if len("VoucherResults") > 8192 {
		return xerrors.Errorf("Value in field \"VoucherResults\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("VoucherResults"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("VoucherResults")); err != nil {
		return err
	}

	if len(t.VoucherResults) > 8192 {
		return xerrors.Errorf("Slice value in field t.VoucherResults was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.VoucherResults))); err != nil {
		return err
	}
	for _, v := range t.VoucherResults {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}

	}

	// t.InitiatorPaused (bool) (bool)
	if len("InitiatorPaused") > 8192 {
		return xerrors.Errorf("Value in field \"InitiatorPaused\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("InitiatorPaused"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("InitiatorPaused")); err != nil {
		return err
	}

	if err := cbg.WriteBool(w, t.InitiatorPaused); err != nil {
		return err
	}

	// t.ResponderPaused (bool) (bool)
	if len("ResponderPaused") > 8192 {
		return xerrors.Errorf("Value in field \"ResponderPaused\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("ResponderPaused"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("ResponderPaused")); err != nil {
		return err
	}

	if err := cbg.WriteBool(w, t.ResponderPaused); err != nil {
		return err
	}

	// t.SentBlocksTotal (int64) (int64)
	if len("SentBlocksTotal") > 8192 {
		return xerrors.Errorf("Value in field \"SentBlocksTotal\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("SentBlocksTotal"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("SentBlocksTotal")); err != nil {
		return err
	}

	if t.SentBlocksTotal >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.SentBlocksTotal)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.SentBlocksTotal-1)); err != nil {
			return err
		}
	}

	// t.QueuedBlocksTotal (int64) (int64)
	if len("QueuedBlocksTotal") > 8192 {
		return xerrors.Errorf("Value in field \"QueuedBlocksTotal\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("QueuedBlocksTotal"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("QueuedBlocksTotal")); err != nil {
		return err
	}

	if t.QueuedBlocksTotal >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.QueuedBlocksTotal)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.QueuedBlocksTotal-1)); err != nil {
			return err
		}
	}

	// t.ReceivedBlocksTotal (int64) (int64)
	if len("ReceivedBlocksTotal") > 8192 {
		return xerrors.Errorf("Value in field \"ReceivedBlocksTotal\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("ReceivedBlocksTotal"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("ReceivedBlocksTotal")); err != nil {
		return err
	}

	if t.ReceivedBlocksTotal >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.ReceivedBlocksTotal)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.ReceivedBlocksTotal-1)); err != nil {
			return err
		}
	}

	// t.RequiresFinalization (bool) (bool)
	if len("RequiresFinalization") > 8192 {
		return xerrors.Errorf("Value in field \"RequiresFinalization\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("RequiresFinalization"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("RequiresFinalization")); err != nil {
		return err
	}

	if err := cbg.WriteBool(w, t.RequiresFinalization); err != nil {
		return err
	}
	return nil
}

func (t *ChannelState) UnmarshalCBOR(r io.Reader) (err error) {
	*t = ChannelState{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("ChannelState: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 8192)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Sent (uint64) (uint64)
		case "Sent":

			{

				maj, extra, err = cr.ReadHeader()
				if err != nil {
					return err
				}
				if maj != cbg.MajUnsignedInt {
					return fmt.Errorf("wrong type for uint64 field")
				}
				t.Sent = uint64(extra)

			}
			// t.Queued (uint64) (uint64)
		case "Queued":

			{

				maj, extra, err = cr.ReadHeader()
				if err != nil {
					return err
				}
				if maj != cbg.MajUnsignedInt {
					return fmt.Errorf("wrong type for uint64 field")
				}
				t.Queued = uint64(extra)

			}
			// t.Sender (peer.ID) (string)
		case "Sender":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.Sender = peer.ID(sval)
			}
			// t.Stages (datatransfer.ChannelStages) (struct)
		case "Stages":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Stages = new(datatransfer.ChannelStages)
					if err := t.Stages.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Stages pointer: %w", err)
					}
				}

			}
			// t.Status (datatransfer.Status) (uint64)
		case "Status":

			{

				maj, extra, err = cr.ReadHeader()
				if err != nil {
					return err
				}
				if maj != cbg.MajUnsignedInt {
					return fmt.Errorf("wrong type for uint64 field")
				}
				t.Status = datatransfer.Status(extra)

			}
			// t.BaseCid (cid.Cid) (struct)
		case "BaseCid":

			{

				c, err := cbg.ReadCid(cr)
				if err != nil {
					return xerrors.Errorf("failed to read cid field t.BaseCid: %w", err)
				}

				t.BaseCid = c

			}
			// t.Message (string) (string)
		case "Message":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.Message = string(sval)
			}
			// t.Received (uint64) (uint64)
		case "Received":

			{

				maj, extra, err = cr.ReadHeader()
				if err != nil {
					return err
				}
				if maj != cbg.MajUnsignedInt {
					return fmt.Errorf("wrong type for uint64 field")
				}
				t.Received = uint64(extra)

			}
			// t.Selector (internal.CborGenCompatibleNode) (struct)
		case "Selector":

			{

				if err := t.Selector.UnmarshalCBOR(cr); err != nil {
					return xerrors.Errorf("unmarshaling t.Selector: %w", err)
				}

			}
			// t.SelfPeer (peer.ID) (string)
		case "SelfPeer":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.SelfPeer = peer.ID(sval)
			}
			// t.Vouchers ([]internal.EncodedVoucher) (slice)
		case "Vouchers":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Vouchers: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Vouchers = make([]EncodedVoucher, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						if err := t.Vouchers[i].UnmarshalCBOR(cr); err != nil {
							return xerrors.Errorf("unmarshaling t.Vouchers[i]: %w", err)
						}

					}

				}
			}
			// t.DataLimit (uint64) (uint64)
		case "DataLimit":

			{

				maj, extra, err = cr.ReadHeader()
				if err != nil {
					return err
				}
				if maj != cbg.MajUnsignedInt {
					return fmt.Errorf("wrong type for uint64 field")
				}
				t.DataLimit = uint64(extra)

			}
			// t.Initiator (peer.ID) (string)
		case "Initiator":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.Initiator = peer.ID(sval)
			}
			// t.Recipient (peer.ID) (string)
		case "Recipient":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.Recipient = peer.ID(sval)
			}
			// t.Responder (peer.ID) (string)
		case "Responder":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.Responder = peer.ID(sval)
			}
			// t.TotalSize (uint64) (uint64)
		case "TotalSize":

			{

				maj, extra, err = cr.ReadHeader()
				if err != nil {
					return err
				}
				if maj != cbg.MajUnsignedInt {
					return fmt.Errorf("wrong type for uint64 field")
				}
				t.TotalSize = uint64(extra)

			}
			// t.TransferID (datatransfer.TransferID) (uint64)
		case "TransferID":

			{

				maj, extra, err = cr.ReadHeader()
				if err != nil {
					return err
				}
				if maj != cbg.MajUnsignedInt {
					return fmt.Errorf("wrong type for uint64 field")
				}
				t.TransferID = datatransfer.TransferID(extra)

			}
			// t.VoucherResults ([]internal.EncodedVoucherResult) (slice)
		case "VoucherResults":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.VoucherResults: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.VoucherResults = make([]EncodedVoucherResult, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						if err := t.VoucherResults[i].UnmarshalCBOR(cr); err != nil {
							return xerrors.Errorf("unmarshaling t.VoucherResults[i]: %w", err)
						}

					}

				}
			}
			// t.InitiatorPaused (bool) (bool)
		case "InitiatorPaused":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}
			if maj != cbg.MajOther {
				return fmt.Errorf("booleans must be major type 7")
			}
			switch extra {
			case 20:
				t.InitiatorPaused = false
			case 21:
				t.InitiatorPaused = true
			default:
				return fmt.Errorf("booleans are either major type 7, value 20 or 21 (got %d)", extra)
			}
			// t.ResponderPaused (bool) (bool)
		case "ResponderPaused":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}
			if maj != cbg.MajOther {
				return fmt.Errorf("booleans must be major type 7")
			}
			switch extra {
			case 20:
				t.ResponderPaused = false
			case 21:
				t.ResponderPaused = true
			default:
				return fmt.Errorf("booleans are either major type 7, value 20 or 21 (got %d)", extra)
			}
			// t.SentBlocksTotal (int64) (int64)
		case "SentBlocksTotal":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.SentBlocksTotal = int64(extraI)
			}
			// t.QueuedBlocksTotal (int64) (int64)
		case "QueuedBlocksTotal":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.QueuedBlocksTotal = int64(extraI)
			}
			// t.ReceivedBlocksTotal (int64) (int64)
		case "ReceivedBlocksTotal":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.ReceivedBlocksTotal = int64(extraI)
			}
			// t.RequiresFinalization (bool) (bool)
		case "RequiresFinalization":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}
			if maj != cbg.MajOther {
				return fmt.Errorf("booleans must be major type 7")
			}
			switch extra {
			case 20:
				t.RequiresFinalization = false
			case 21:
				t.RequiresFinalization = true
			default:
				return fmt.Errorf("booleans are either major type 7, value 20 or 21 (got %d)", extra)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *EncodedVoucher) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.Type (datatransfer.TypeIdentifier) (string)
	if len("Type") > 8192 {
		return xerrors.Errorf("Value in field \"Type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Type")); err != nil {
		return err
	}

	if len(t.Type) > 8192 {
		return xerrors.Errorf("Value in field t.Type was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Type))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Type)); err != nil {
		return err
	}

	// t.Voucher (internal.CborGenCompatibleNode) (struct)
	if len("Voucher") > 8192 {
		return xerrors.Errorf("Value in field \"Voucher\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Voucher"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Voucher")); err != nil {
		return err
	}

	if err := t.Voucher.MarshalCBOR(cw); err != nil {
		return err
	}
	return nil
}

func (t *EncodedVoucher) UnmarshalCBOR(r io.Reader) (err error) {
	*t = EncodedVoucher{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("EncodedVoucher: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 8192)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Type (datatransfer.TypeIdentifier) (string)
		case "Type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.Type = datatransfer.TypeIdentifier(sval)
			}
			// t.Voucher (internal.CborGenCompatibleNode) (struct)
		case "Voucher":

			{

				if err := t.Voucher.UnmarshalCBOR(cr); err != nil {
					return xerrors.Errorf("unmarshaling t.Voucher: %w", err)
				}

			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *EncodedVoucherResult) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.Type (datatransfer.TypeIdentifier) (string)
	if len("Type") > 8192 {
		return xerrors.Errorf("Value in field \"Type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Type")); err != nil {
		return err
	}

	if len(t.Type) > 8192 {
		return xerrors.Errorf("Value in field t.Type was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Type))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Type)); err != nil {
		return err
	}

	// t.VoucherResult (internal.CborGenCompatibleNode) (struct)
	if len("VoucherResult") > 8192 {
		return xerrors.Errorf("Value in field \"VoucherResult\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("VoucherResult"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("VoucherResult")); err != nil {
		return err
	}

	if err := t.VoucherResult.MarshalCBOR(cw); err != nil {
		return err
	}
	return nil
}

func (t *EncodedVoucherResult) UnmarshalCBOR(r io.Reader) (err error) {
	*t = EncodedVoucherResult{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("EncodedVoucherResult: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 8192)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Type (datatransfer.TypeIdentifier) (string)
		case "Type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.Type = datatransfer.TypeIdentifier(sval)
			}
			// t.VoucherResult (internal.CborGenCompatibleNode) (struct)
		case "VoucherResult":

			{

				if err := t.VoucherResult.UnmarshalCBOR(cr); err != nil {
					return xerrors.Errorf("unmarshaling t.VoucherResult: %w", err)
				}

			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
