// Code generated by github.com/whyrusleeping/cbor-gen. DO NOT EDIT.

package datatransfer

import (
	"fmt"
	"io"
	"math"
	"sort"

	cid "github.com/ipfs/go-cid"
	peer "github.com/libp2p/go-libp2p/core/peer"
	cbg "github.com/whyrusleeping/cbor-gen"
	xerrors "golang.org/x/xerrors"
)

var _ = xerrors.Errorf
var _ = cid.Undef
var _ = math.E
var _ = sort.Sort

var lengthBufChannelID = []byte{131}

func (t *ChannelID) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write(lengthBufChannelID); err != nil {
		return err
	}

	// t.Initiator (peer.ID) (string)
	if len(t.Initiator) > 8192 {
		return xerrors.Errorf("Value in field t.Initiator was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Initiator))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Initiator)); err != nil {
		return err
	}

	// t.Responder (peer.ID) (string)
	if len(t.Responder) > 8192 {
		return xerrors.Errorf("Value in field t.Responder was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Responder))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Responder)); err != nil {
		return err
	}

	// t.ID (datatransfer.TransferID) (uint64)

	if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.ID)); err != nil {
		return err
	}

	return nil
}

func (t *ChannelID) UnmarshalCBOR(r io.Reader) (err error) {
	*t = ChannelID{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajArray {
		return fmt.Errorf("cbor input should be of type array")
	}

	if extra != 3 {
		return fmt.Errorf("cbor input had wrong number of fields")
	}

	// t.Initiator (peer.ID) (string)

	{
		sval, err := cbg.ReadStringWithMax(cr, 8192)
		if err != nil {
			return err
		}

		t.Initiator = peer.ID(sval)
	}
	// t.Responder (peer.ID) (string)

	{
		sval, err := cbg.ReadStringWithMax(cr, 8192)
		if err != nil {
			return err
		}

		t.Responder = peer.ID(sval)
	}
	// t.ID (datatransfer.TransferID) (uint64)

	{

		maj, extra, err = cr.ReadHeader()
		if err != nil {
			return err
		}
		if maj != cbg.MajUnsignedInt {
			return fmt.Errorf("wrong type for uint64 field")
		}
		t.ID = TransferID(extra)

	}
	return nil
}

var lengthBufChannelStages = []byte{129}

func (t *ChannelStages) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write(lengthBufChannelStages); err != nil {
		return err
	}

	// t.Stages ([]*datatransfer.ChannelStage) (slice)
	if len(t.Stages) > 8192 {
		return xerrors.Errorf("Slice value in field t.Stages was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Stages))); err != nil {
		return err
	}
	for _, v := range t.Stages {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}

	}
	return nil
}

func (t *ChannelStages) UnmarshalCBOR(r io.Reader) (err error) {
	*t = ChannelStages{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajArray {
		return fmt.Errorf("cbor input should be of type array")
	}

	if extra != 1 {
		return fmt.Errorf("cbor input had wrong number of fields")
	}

	// t.Stages ([]*datatransfer.ChannelStage) (slice)

	maj, extra, err = cr.ReadHeader()
	if err != nil {
		return err
	}

	if extra > 8192 {
		return fmt.Errorf("t.Stages: array too large (%d)", extra)
	}

	if maj != cbg.MajArray {
		return fmt.Errorf("expected cbor array")
	}

	if extra > 0 {
		t.Stages = make([]*ChannelStage, extra)
	}

	for i := 0; i < int(extra); i++ {
		{
			var maj byte
			var extra uint64
			var err error
			_ = maj
			_ = extra
			_ = err

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Stages[i] = new(ChannelStage)
					if err := t.Stages[i].UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Stages[i] pointer: %w", err)
					}
				}

			}

		}
	}
	return nil
}

var lengthBufChannelStage = []byte{133}

func (t *ChannelStage) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write(lengthBufChannelStage); err != nil {
		return err
	}

	// t.Name (string) (string)
	if len(t.Name) > 8192 {
		return xerrors.Errorf("Value in field t.Name was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Name))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Name)); err != nil {
		return err
	}

	// t.Description (string) (string)
	if len(t.Description) > 8192 {
		return xerrors.Errorf("Value in field t.Description was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Description))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Description)); err != nil {
		return err
	}

	// t.CreatedTime (typegen.CborTime) (struct)
	if err := t.CreatedTime.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.UpdatedTime (typegen.CborTime) (struct)
	if err := t.UpdatedTime.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Logs ([]*datatransfer.Log) (slice)
	if len(t.Logs) > 8192 {
		return xerrors.Errorf("Slice value in field t.Logs was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Logs))); err != nil {
		return err
	}
	for _, v := range t.Logs {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}

	}
	return nil
}

func (t *ChannelStage) UnmarshalCBOR(r io.Reader) (err error) {
	*t = ChannelStage{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajArray {
		return fmt.Errorf("cbor input should be of type array")
	}

	if extra != 5 {
		return fmt.Errorf("cbor input had wrong number of fields")
	}

	// t.Name (string) (string)

	{
		sval, err := cbg.ReadStringWithMax(cr, 8192)
		if err != nil {
			return err
		}

		t.Name = string(sval)
	}
	// t.Description (string) (string)

	{
		sval, err := cbg.ReadStringWithMax(cr, 8192)
		if err != nil {
			return err
		}

		t.Description = string(sval)
	}
	// t.CreatedTime (typegen.CborTime) (struct)

	{

		if err := t.CreatedTime.UnmarshalCBOR(cr); err != nil {
			return xerrors.Errorf("unmarshaling t.CreatedTime: %w", err)
		}

	}
	// t.UpdatedTime (typegen.CborTime) (struct)

	{

		if err := t.UpdatedTime.UnmarshalCBOR(cr); err != nil {
			return xerrors.Errorf("unmarshaling t.UpdatedTime: %w", err)
		}

	}
	// t.Logs ([]*datatransfer.Log) (slice)

	maj, extra, err = cr.ReadHeader()
	if err != nil {
		return err
	}

	if extra > 8192 {
		return fmt.Errorf("t.Logs: array too large (%d)", extra)
	}

	if maj != cbg.MajArray {
		return fmt.Errorf("expected cbor array")
	}

	if extra > 0 {
		t.Logs = make([]*Log, extra)
	}

	for i := 0; i < int(extra); i++ {
		{
			var maj byte
			var extra uint64
			var err error
			_ = maj
			_ = extra
			_ = err

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Logs[i] = new(Log)
					if err := t.Logs[i].UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Logs[i] pointer: %w", err)
					}
				}

			}

		}
	}
	return nil
}

var lengthBufLog = []byte{130}

func (t *Log) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write(lengthBufLog); err != nil {
		return err
	}

	// t.Log (string) (string)
	if len(t.Log) > 8192 {
		return xerrors.Errorf("Value in field t.Log was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Log))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Log)); err != nil {
		return err
	}

	// t.UpdatedTime (typegen.CborTime) (struct)
	if err := t.UpdatedTime.MarshalCBOR(cw); err != nil {
		return err
	}
	return nil
}

func (t *Log) UnmarshalCBOR(r io.Reader) (err error) {
	*t = Log{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajArray {
		return fmt.Errorf("cbor input should be of type array")
	}

	if extra != 2 {
		return fmt.Errorf("cbor input had wrong number of fields")
	}

	// t.Log (string) (string)

	{
		sval, err := cbg.ReadStringWithMax(cr, 8192)
		if err != nil {
			return err
		}

		t.Log = string(sval)
	}
	// t.UpdatedTime (typegen.CborTime) (struct)

	{

		if err := t.UpdatedTime.UnmarshalCBOR(cr); err != nil {
			return xerrors.Errorf("unmarshaling t.UpdatedTime: %w", err)
		}

	}
	return nil
}
